/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;

public class BeeFishingRecipeCategory
implements IRecipeCategory<BeeFishingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BeeFishingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_fishing_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 110);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42523_));
    }

    @Nonnull
    @Deprecated
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_BEE_FISHING_UID;
    }

    @Nonnull
    @Deprecated
    public Class<? extends BeeFishingRecipe> getRecipeClass() {
        return BeeFishingRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.bee_fishing");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(BeeFishingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        boolean xPos = false;
        AtomicInteger yPos = new AtomicInteger(45);
        Minecraft minecraft = Minecraft.m_91087_();
        for (Biome biome : BeeFishingRecipe.getBiomeList(recipe)) {
            minecraft.f_91062_.m_92877_(poseStack, Language.m_128107_().m_5536_((FormattedText)new TranslatableComponent("biome.minecraft." + biome.getRegistryName().m_135815_())), (float)xPos, (float)yPos.get(), -16777216);
            Objects.requireNonNull(minecraft.f_91062_);
            yPos.addAndGet(9 + 2);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BeeFishingRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 17).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)((BeeIngredient)recipe.output.get()))).setSlotName("source");
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(VanillaTypes.ITEM, Arrays.asList(Ingredient.m_204132_(ModTags.Forge.EGGS).m_43908_()));
    }
}

